---
name: r.stream.variables.sh
description: Calculation of contiguous stream-specific variables that account for the upstream environment (based on r.stream.watersheds).
keywords: [ raster, stream, drainage, hydrology ]
---

# r.stream.variables.sh

Calculation of contiguous stream-specific variables that account for the upstream environment (based on r.stream.watersheds).

=== "Command line"

    **r.stream.variables.sh**
    **variable**=*name*
    **area**=*string*
    [**folder**=*name*]
    [**out_folder**=*name*]
    **output**=*method* [,*method*,...]
    [**scale**=*value*]
    [**cpu**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.stream.variables.sh variable=name area=watershed output=cells
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.stream.variables.sh***",
        **variable**,
        **area**,
        **folder**=*"GISDBASE/folder_structure"*,
        **out_folder**=*"GISDBASE/stream-specific_variables"*,
        **output**,
        **scale**=*1*,
        **cpu**=*1*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.stream.variables.sh", variable="name", area="watershed", output="cells")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_stream_variables_sh*(**variable**,
        **area**,
        **folder**=*"GISDBASE/folder_structure"*,
        **out_folder**=*"GISDBASE/stream-specific_variables"*,
        **output**,
        **scale**=*1*,
        **cpu**=*1*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_stream_variables_sh(variable="name", area="watershed", output="cells")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **variable**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to be converted into a stream-specific variable  
    **area**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Area of aggregation: across the sub-watersheds or only across sub-streams  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *watershed, stream*  
    **folder**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path (same as for r.stream.watersheds)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/folder_structure*  
    **out_folder**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path for the output stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/stream-specific_variables*  
    **output**=*method* [,*method*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the output aggregation method for the stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;upstream cells numbers, minimum, maximum, range, mean, standard deviation, coefficient of variation, sum. Output datatype is Int32  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cells, min, max, range, mean, stddev, coeff_var, sum*  
    **scale**=*value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide a scale factor to multiply or divide the final stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide it e.g. if input raster values are between -1 and 1, use scale=1000 to inicrease the number of decimals - all outputs will be rounded to integers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cpu**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of CPUs used for the parallel computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **variable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to be converted into a stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **area** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area of aggregation: across the sub-watersheds or only across sub-streams  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *watershed, stream*  
    **folder** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path (same as for r.stream.watersheds)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/folder_structure*  
    **out_folder** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path for the output stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/stream-specific_variables*  
    **output** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the output aggregation method for the stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;upstream cells numbers, minimum, maximum, range, mean, standard deviation, coefficient of variation, sum. Output datatype is Int32  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *method*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cells, min, max, range, mean, stddev, coeff_var, sum*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide a scale factor to multiply or divide the final stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide it e.g. if input raster values are between -1 and 1, use scale=1000 to inicrease the number of decimals - all outputs will be rounded to integers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cpu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of CPUs used for the parallel computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **variable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster to be converted into a stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **area** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Area of aggregation: across the sub-watersheds or only across sub-streams  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *watershed, stream*  
    **folder** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path (same as for r.stream.watersheds)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/folder_structure*  
    **out_folder** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path for the output stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/stream-specific_variables*  
    **output** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the output aggregation method for the stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;upstream cells numbers, minimum, maximum, range, mean, standard deviation, coefficient of variation, sum. Output datatype is Int32  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *method*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *cells, min, max, range, mean, stddev, coeff_var, sum*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide a scale factor to multiply or divide the final stream-specific variable  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide it e.g. if input raster values are between -1 and 1, use scale=1000 to inicrease the number of decimals - all outputs will be rounded to integers  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *value*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cpu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of CPUs used for the parallel computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Calculation of contiguous stream-specific variables that account for the
upstream environment (based on r.stream.watersheds).

## REFERENCES

Sami Domisch, Giuseppe Amatulli, Walter Jetz (2015): *Near-global
freshwater-specific environmental variables for biodiversity analyses in
1 km resolution*, Scientific Data 2, 150073,
[DOI:10.1038/sdata.2015.73](https://dx.doi.org/10.1038/sdata.2015.73)

## AUTHORS

Giuseppe Amatulli  
Sami Domisch

## SOURCE CODE

Available at: [r.stream.variables source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.stream.variables)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.stream.variables))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
