---
name: r.stream.watersheds.sh
description: Sub-watershed and sub-stream delineation based on the drainage direction and a gridded stream network.
keywords: [ raster, stream, drainage, hydrology ]
---

# r.stream.watersheds.sh

Sub-watershed and sub-stream delineation based on the drainage direction and a gridded stream network.

=== "Command line"

    **r.stream.watersheds.sh**
    **drainage**=*name*
    **stream**=*name*
    [**folder**=*name*]
    [**cpu**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.stream.watersheds.sh drainage=name stream=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.stream.watersheds.sh***",
        **drainage**,
        **stream**,
        **folder**=*"GISDBASE/folder_structure"*,
        **cpu**=*1*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.stream.watersheds.sh", drainage="name", stream="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_stream_watersheds_sh*(**drainage**,
        **stream**,
        **folder**=*"GISDBASE/folder_structure"*,
        **cpu**=*1*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_stream_watersheds_sh(drainage="name", stream="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **drainage**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the drainage direction raster (generated with r.watershed)  
    **stream**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the stream network raster  
    **folder**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path and name where the sub-watersheds and sub-streams should be stored  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/folder_structure*  
    **cpu**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of CPUs used for the parallel computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **drainage** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the drainage direction raster (generated with r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **stream** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the stream network raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **folder** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path and name where the sub-watersheds and sub-streams should be stored  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/folder_structure*  
    **cpu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of CPUs used for the parallel computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **drainage** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the drainage direction raster (generated with r.watershed)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **stream** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the stream network raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **folder** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Provide the full folder path and name where the sub-watersheds and sub-streams should be stored  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *GISDBASE/folder_structure*  
    **cpu** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of CPUs used for the parallel computation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Delineate the upstream contributing area ('sub-watershed') and stream
sections ('sub-stream') for each grid cell of a stream network.

## REFERENCES

Sami Domisch, Giuseppe Amatulli, Walter Jetz (2015): *Near-global
freshwater-specific environmental variables for biodiversity analyses in
1 km resolution*, Scientific Data 2, 150073,
[DOI:10.1038/sdata.2015.73](https://dx.doi.org/10.1038/sdata.2015.73)

## AUTHORS

Giuseppe Amatulli  
Sami Domisch

## SOURCE CODE

Available at: [r.stream.watersheds source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.stream.watersheds)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.stream.watersheds))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
