---
name: r.surf.nnbathy.py
description: Interpolates a raster map using the nnbathy natural neighbor interpolation program.
keywords: [ vector, surface, interpolation, natural, neighbor ]
---

# r.surf.nnbathy.py

Interpolates a raster map using the nnbathy natural neighbor interpolation program.

=== "Command line"

    **r.surf.nnbathy.py**
    **input**=*name*
    **output**=*name*
    [**algorithm**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.surf.nnbathy.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.surf.nnbathy.py***",
        **input**,
        **output**,
        **algorithm**=*"nn"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.surf.nnbathy.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_surf_nnbathy_py*(**input**,
        **output**,
        **algorithm**=*"nn"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_surf_nnbathy_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map  
    **algorithm**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Settings  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l, nn, ns*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nn*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**: Linear  
    &nbsp;&nbsp;&nbsp;&nbsp;**nn**: Sibson natural neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**ns**: Non-Sibsonian natural neighbor  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **algorithm** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Settings  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l, nn, ns*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**: Linear  
    &nbsp;&nbsp;&nbsp;&nbsp;**nn**: Sibson natural neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**ns**: Non-Sibsonian natural neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nn*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **algorithm** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Settings  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *l, nn, ns*  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**: Linear  
    &nbsp;&nbsp;&nbsp;&nbsp;**nn**: Sibson natural neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;**ns**: Non-Sibsonian natural neighbor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nn*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.surf.nnbathy* is an interface between the external *nnbathy* utility
and *GRASS*. *nnbathy* is a surface interpolation program provided with
[nn](https://github.com/sakov/nn-c) - a natural neighbor interpolation
library, written by Pavel Sakov.

*r.surf.nnbathy* provides 3 interpolation algorithms. According to *nn*
library documentation these are: Delaunay interpolation (**alg=l**),
Watson's algortithm for Sibson natural neighbor interpolation
(**alg=nn**) and Belikov and Semenov's algorithm for non-Sibsonian
natural neighbor interpolation (**alg=ns**). For performing the
underlaying Delaunay triangulation in all cases *nnbathy* uses
*triangle* software by [Jonathan Richard
Shewchuk](http://www.cs.berkeley.edu/~jrs/).

The **output** raster map is a continous surface interpolated from the
**input** data.

## NOTES

*nnbathy*, if built with '-DNN\_SERIAL' (default as of nn 1.85), is able
to create a grid of virtually any size. It interpolates and writes one
output point at a time only. This eliminates the necessity to hold the
whole output array in memory. However, even then all the input points
are still held in the memory.

1. Requires *GRASS* 7 and *nnbathy* 1.76 or greater.
2. Build *nnbathy* according to instructions provided with its source
    code and put it somewhere in your $PATH.
3. The output raster map extent and resolution match the region
    settings at which the script was started.
4. The output raster map non-NULL area is limited to the convex hull
    encompassing all the non-NULL input cells.
5. The output is double precision floating point raster map (DCELL).
6. Natural neighbor is a an *exact* interpolation algorithm, so all
    non-NULL input points have their value exactly preserved in the
    output.
7. There is circa 0.2 KB memory overhead per each *input* cell.
    However, the *output* grid can be of any size, if *nnbathy* is built
    with -DNN\_SERIAL switch.
8. *r.surf.nnbathy* creates 3 temporary files: ASCII x,y,z lists of the
    input points and output cells, and the output list converted into
    GRASS ASCII format. Then it makes a GRASS raster map from the latter
    - and only then it removes the 3 temp files, when the script
    terminates. Thus, at the script run time several times more disk
    space might be required, than the final GRASS raster map would
    actually occupy.

## EXAMPLE

```sh
g.region raster=elevation@PERMANENT -p
r.random input=elevation@PERMANENT n=100000 raster_output=random_points
r.surf.nnbathy input=random_points output=raster_map
d.rast map=raster_map
```

## REQUIREMENTS

- [nnbathy](https://github.com/sakov/nn-c) library by Pavel Sakov
- *[v.surf.nnbathy](v.surf.nnbathy.md)*

## SEE ALSO

*[v.surf.nnbathy](v.surf.nnbathy.md)*

## AUTHOR

Adam Laza, OSGeoREL, Czech Technical University in Prague (mentor:
Martin Landa)

based on v.surf.nnbathy from GRASS 6 by  
Hamish Bowman, Otago University, New Zealand  
Based on *r.surf.nnbathy* by Maciej Sieczka

## SOURCE CODE

Available at: [r.surf.nnbathy source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.surf.nnbathy)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.surf.nnbathy))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
