---
name: r.to.vect.tiled.py
description: Converts a raster map into vector tiles.
keywords: [ raster, conversion, geometry, vectorization, tiling ]
---

# r.to.vect.tiled.py

Converts a raster map into vector tiles.

=== "Command line"

    **r.to.vect.tiled.py**
    [**-svzbtp**]
    **input**=*name*
    **output**=*string*
    **type**=*string*
    [**column**=*name*]
    [**x**=*integer*]
    [**y**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.to.vect.tiled.py input=name output=string type=point
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.to.vect.tiled.py***",
        **input**,
        **output**,
        **type**,
        **column**=*"value"*,
        **x**=*2*,
        **y**=*2*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.to.vect.tiled.py", input="name", output="string", type="point")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_to_vect_tiled_py*(**input**,
        **output**,
        **type**,
        **column**=*"value"*,
        **x**=*2*,
        **y**=*2*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_to_vect_tiled_py(input="name", output="string", type="point")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output base name  
    **type**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to store value  
    &nbsp;&nbsp;&nbsp;&nbsp;Name must be SQL compliant  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *value*  
    **x**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tiles in x direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **y**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tiles in y direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Smooth corners of linear features  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use raster values as categories instead of unique sequence (CELL only)  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Write raster values as z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;Table is not created. Currently supported only for points.  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build vector topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Recommended for massive point conversion  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Patch the tiles  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output base name  
    **type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to store value  
    &nbsp;&nbsp;&nbsp;&nbsp;Name must be SQL compliant  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *value*  
    **x** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tiles in x direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **y** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tiles in y direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *v*, *z*, *b*, *t*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Smooth corners of linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use raster values as categories instead of unique sequence (CELL only)  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write raster values as z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Table is not created. Currently supported only for points.  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build vector topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recommended for massive point conversion  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Patch the tiles  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output base name  
    **type** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to store value  
    &nbsp;&nbsp;&nbsp;&nbsp;Name must be SQL compliant  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *value*  
    **x** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tiles in x direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **y** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of tiles in y direction  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*, *v*, *z*, *b*, *t*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Smooth corners of linear features  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use raster values as categories instead of unique sequence (CELL only)  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write raster values as z coordinate  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Table is not created. Currently supported only for points.  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build vector topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Recommended for massive point conversion  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Patch the tiles  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.to.vect.tiled* vectorizes the **input** raster map and produces
several tiled vector maps covering the current region.

Vectorizing a large raster map with *r.to.vect* can require a lot of
memory. In these cases, *r.to.vect.tiled* can reduce memory usage by
vectorizing each tile separately.

The tiles are optionally patched together with the *-p* flag.

## SEE ALSO

*[r.to.vect](https://grass.osgeo.org/grass-stable/manuals/r.to.vect.html),
[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[v.patch](https://grass.osgeo.org/grass-stable/manuals/v.patch.html),
[r.thin](https://grass.osgeo.org/grass-stable/manuals/r.thin.html),
[v.clean](https://grass.osgeo.org/grass-stable/manuals/v.clean.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [r.to.vect.tiled source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.to.vect.tiled)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.to.vect.tiled))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
