---
name: r.tri.py
description: Computes the Terrain Ruggedness Index.
keywords: [ raster, surface, terrain, ruggedness, parallel ]
---

# r.tri.py

Computes the Terrain Ruggedness Index.

=== "Command line"

    **r.tri.py**
    [**-c**]
    **input**=*name*
    **output**=*name*
    **size**=*integer*
    [**exponent**=*float*]
    [**processes**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.tri.py input=name output=name size=3
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.tri.py***",
        **input**,
        **output**,
        **size**=*3*,
        **exponent**=*0.0*,
        **processes**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.tri.py", input="name", output="name", size=3)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_tri_py*(**input**,
        **output**,
        **size**=*3*,
        **exponent**=*0.0*,
        **processes**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_tri_py(input="name", output="name", size=3)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation raster  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Terrain Ruggedness Index (TRI)  
    **size**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood in cells (&gt; 2 and &lt;= 51)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **exponent**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance weighting exponent (&gt;= 0 and &lt;= 4.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **processes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processing cores for tiled calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processing cores for tiled calculation (negative numbers are all cpus -1, -2 etc.)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use circular neighborhood  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Terrain Ruggedness Index (TRI)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood in cells (&gt; 2 and &lt;= 51)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **exponent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance weighting exponent (&gt;= 0 and &lt;= 4.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processing cores for tiled calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processing cores for tiled calculation (negative numbers are all cpus -1, -2 etc.)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use circular neighborhood  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Terrain Ruggedness Index (TRI)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **size** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood in cells (&gt; 2 and &lt;= 51)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **exponent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Distance weighting exponent (&gt;= 0 and &lt;= 4.0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **processes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processing cores for tiled calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processing cores for tiled calculation (negative numbers are all cpus -1, -2 etc.)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use circular neighborhood  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.tri* calculates the Terrain Ruggedness Index (TRI) of Riley et al.
(1999). The index represents the mean change in elevation between a grid
cell and its neighbours, over a user-specified moving window size. The
original calculation in Riley et al. (1999) used only a 3x3
neighbourhood and represented the sum of the absolute deviations between
the center pixel and its immediate 8 neighbours. In r.tri, this
calculation is modified so that the calculation can be extended over any
scale by taking the mean of the absolute deviations.

## NOTES

*r.tri* produces fairly similar results to the average deviation of
elevation values, apart from the center pixel is used in place of the
mean. In practice, this produces a slightly less smoothed result that
can potentially highlight finer-scale terrain features. However, because
the terrain ruggedness index does not consider the distance of each cell
from the centre cell in it's calculation, the TRI results can become
noisy with large window sizes. To avoid this, weighting each cell by the
inverse of its distance can be used by setting the *exponent* parameter
to \> 0.

Similar to many other GRASS GIS algorithms, cell padding is not
performed automatically which will leave null values at the boundaries
of the output raster relative to the size of the input raster. To
minimize this effect the DEM needs to be buffered/grown prior to using
r.tri.

Currently, *r.tri* is implemented using a *r.mapcalc* focal function.
This becomes slow for large window sizes. To reduce computational times
for large raster datasets, setting *processes* parameter to \> 1 will
use a parallelized and tiled calculations that is spread across multiple
processing cores. This option requires the GRASS addon
[r.mapcalc.tiled](r.mapcalc.tiled.md) to be installed.

## EXAMPLE

```sh
d.rast map=elev_lid792_1m@PERMANENT
g.region raster=elev_lid792_1m@PERMANENT -a
r.tri input=elev_lid792_1m@PERMANENT size=9 output=tri
```

![image-alt](r_tri.png)

## REFERENCES

Riley, S. J., S. D. DeGloria and R. Elliot (1999). A terrain ruggedness
index that quantifies topographic heterogeneity, Intermountain Journal
of Sciences, vol. 5, No. 1-4, 1999.

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.mapcalc.tiled](r.mapcalc.tiled.md)*

## AUTHOR

Steven Pawley

## SOURCE CODE

Available at: [r.tri source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.tri)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.tri))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
