---
name: r.vect.stats.py
description: Bins vector points into a raster map.
keywords: [ raster, vector, points, binning ]
---

# r.vect.stats.py

Bins vector points into a raster map.

=== "Command line"

    **r.vect.stats.py**
    **input**=*name*
    **output**=*name*
    [**column**=*name*]
    [**method**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.vect.stats.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.vect.stats.py***",
        **input**,
        **output**,
        **column**=*None*,
        **method**=*"mean"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.vect.stats.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_vect_stats_py*(**input**,
        **output**,
        **column**=*None*,
        **method**=*"mean"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_vect_stats_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column for statistics  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistic to use for raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**: Number of points in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**range**: Range of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Mean (average) value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**coeff_var**: Coefficient of variance of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Median value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**percentile**: Pth (nth) percentile of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewness of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**trimmean**: Trimmed mean of point values in cell  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistic to use for raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**: Number of points in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**range**: Range of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Mean (average) value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**coeff_var**: Coefficient of variance of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Median value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**percentile**: Pth (nth) percentile of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewness of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**trimmean**: Trimmed mean of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistic to use for raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n, min, max, range, sum, mean, stddev, variance, coeff_var, median, percentile, skewness, trimmean*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**: Number of points in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**min**: Minimum value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**max**: Maximum value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**range**: Range of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**sum**: Sum of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**mean**: Mean (average) value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**stddev**: Standard deviation of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**variance**: Variance of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**coeff_var**: Coefficient of variance of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**median**: Median value of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**percentile**: Pth (nth) percentile of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**skewness**: Skewness of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;**trimmean**: Trimmed mean of point values in cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mean*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.vect.stats* bins points from a vector map into a raster map.

Use
*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html)*
to set the extent and resolution of the resulting raster.

## EXAMPLES

Calculate number of schools in grid of spatial resolution 1km:

```sh
g.region res=1000 vector=schools_wake
r.vect.stats input=schools_wake output=schools_count
```

Calculate sum of atribute column CAPACITYTO:

```sh
r.vect.stats input=schools_wake output=schools_capacity_sum column=CAPACITYTO method=sum
```

![image-alt](r_to_vect_schools_count.png)
![image-alt](r_to_vect_schools_sum.png)  
*Figure: Number of schools (left part) and sum of CAPACITYTO attribute
column (right part) in grid of spatial resolution 1km.*

## SEE ALSO

*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[v.out.ascii](https://grass.osgeo.org/grass-stable/manuals/v.out.ascii.html),
[r.in.xyz](https://grass.osgeo.org/grass-stable/manuals/r.in.xyz.html),
[r.in.lidar](https://grass.osgeo.org/grass-stable/manuals/r.in.lidar.html)*

## AUTHORS

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)  
Column and method parameters added by Martin Landa, [CTU GeoForAll
Lab](https://geomatics.fsv.cvut.cz/research/geoforall/)

## SOURCE CODE

Available at: [r.vect.stats source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.vect.stats)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.vect.stats))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
