---
name: r.water.outlet
description: Creates watershed basins from a drainage direction map.
keywords: [ raster, hydrology, watershed ]
---

# r.water.outlet

Creates watershed basins from a drainage direction map.

=== "Command line"

    **r.water.outlet**
    **input**=*name*
    **output**=*name*
    **coordinates**=*east,north*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.water.outlet input=name output=name coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.water.outlet***",
        **input**,
        **output**,
        **coordinates**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.water.outlet", input="name", output="name", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_water_outlet*(**input**,
        **output**,
        **coordinates**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_water_outlet(input="name", output="name", coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input drainage direction map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output watershed basin map  
    **coordinates**=*east,north* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates of outlet point  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input drainage direction map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output watershed basin map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates of outlet point  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input drainage direction map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output watershed basin map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **coordinates** : tuple[float, float] | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Coordinates of outlet point  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.water.outlet* generates a watershed basin from a drainage direction
map and a set of coordinates representing the outlet point of the watershed.

Input drainage direction map indicates the "aspect" for each cell.
Multiplying positive values by 45 will give the direction in degrees
that the surface runoff will travel from that cell. The value -1
indicates that the cell is a depression area. Other negative values
indicate that surface runoff is leaving the boundaries of the current
geographic region. The absolute value of these negative cells indicates
the direction of flow. This raster map is generated from
*[r.watershed](r.watershed.md)*.

Output raster map values of one (1) indicate the watershed basin. Values
of zero (0) are not in the watershed basin.

## NOTES

In the context of this program, a watershed basin is the region upstream
of an outlet point. Thus, if the user chooses an outlet point on a hill
slope, the resulting map will be a thin sliver of land representing the
overland slope uphill of the point.

## EXAMPLE

A watershed in the [North Carolina sample
dataset](https://grass.osgeo.org/download/data/) region:

```sh
g.region raster=elev_lid792_1m -p
# the watershed outlet position should be placed on a stream (from
# accumulation map):
r.watershed elev_lid792_1m threshold=5000 accumulation=accum_5K drainage=draindir_5K basin=basin_5K
r.water.outlet input=draindir_5K output=basin_A30 coordinates=638740.423248,220271.519225

d.mon wx0
d.rast map=accum_5K
d.rast map=basin_A30

# overlay with transparency
r.colors map=basin_A30 color=grey
d.his h=accum_5K i=basin_A30

# report outlet size in ha
r.report map=basin_A30 units=h
```

![Figure: Watershed draped over flow accumulation](r_water_outlet.png)  
*Figure: Watershed draped over flow accumulation*

## SEE ALSO

*[r.wateroutlet.lessmem](https://grass.osgeo.org/grass8/manuals/addons/r.wateroutlet.lessmem.html)
(addon), [d.where](d.where.md), [r.basins.fill](r.basins.fill.md),
[r.watershed](r.watershed.md), [r.topidx](r.topidx.md)*

## AUTHOR

Charles Ehlschlaeger, U.S. Army Construction Engineering Research
Laboratory

## SOURCE CODE

Available at: [r.water.outlet source code](https://github.com/OSGeo/grass/tree/main/raster/r.water.outlet)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.water.outlet))  
Latest change: Tuesday Jul 01 10:05:22 2025 in commit [041dfcd](https://github.com/OSGeo/grass/commit/041dfcd0bde6bac18b7065ee697e80f0e5620073)
