---
name: r3.in.lidar
description: Creates a 3D raster map from LAS LiDAR points using univariate statistics.
keywords: [ raster3d, import, LIDAR, statistics, conversion, aggregation, binning ]
---

# r3.in.lidar

Creates a 3D raster map from LAS LiDAR points using univariate statistics.

=== "Command line"

    **r3.in.lidar**
    [**-dvopsg**]
    [**input**=*name*]
    [**file**=*name*]
    [**n**=*name*]
    [**sum**=*name*]
    [**mean**=*name*]
    [**proportional_n**=*name*]
    [**proportional_sum**=*name*]
    [**return_filter**=*string*]
    [**class_filter**=*integer* [,*integer*,...]]
    [**base_raster**=*name*]
    [**zscale**=*float*]
    [**intensity_range**=*min,max*]
    [**intensity_scale**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.in.lidar input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.in.lidar***",
        **input**=*None*,
        **file**=*None*,
        **n**=*None*,
        **sum**=*None*,
        **mean**=*None*,
        **proportional_n**=*None*,
        **proportional_sum**=*None*,
        **return_filter**=*None*,
        **class_filter**=*None*,
        **base_raster**=*None*,
        **zscale**=*1.0*,
        **intensity_range**=*None*,
        **intensity_scale**=*1.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.in.lidar", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_in_lidar*(**input**=*None*,
        **file**=*None*,
        **n**=*None*,
        **sum**=*None*,
        **mean**=*None*,
        **proportional_n**=*None*,
        **proportional_sum**=*None*,
        **return_filter**=*None*,
        **class_filter**=*None*,
        **base_raster**=*None*,
        **zscale**=*1.0*,
        **intensity_range**=*None*,
        **intensity_scale**=*1.0*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_in_lidar(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS input file  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input file in LAS format (\*.las or \*.laz)  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing names of LAS input files  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input files in LAS format (\*.las or \*.laz)  
    **n**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Count of points per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **sum**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sum of values of point intensities per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **mean**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean of point intensities per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **proportional_n**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map of proportional point count  
    &nbsp;&nbsp;&nbsp;&nbsp;Point count per 3D cell divided by point count per vertical column  
    **proportional_sum**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map of proportional sum of values  
    &nbsp;&nbsp;&nbsp;&nbsp;Sum of values per 3D cell divided by sum of values per vertical column  
    **return_filter**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected return type  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, all points are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *first, last, mid*  
    **class_filter**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected class(es)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is comma separated integers. If not specified, all points are imported.  
    **base_raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtract raster values from the z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;The scale for z is applied beforehand, the filter afterwards  
    **zscale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale to apply to Z data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **intensity_range**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for intensity values (min,max)  
    **intensity_scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale to apply to intensity values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use base raster actual resolution instead of computational region  
    **-v**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use only valid points  
    &nbsp;&nbsp;&nbsp;&nbsp;Points invalid according to APSRS LAS specification will be filtered out  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print LAS file info and exit  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Scan data file for extent then exit  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;In scan mode, print using shell script style  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS input file  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input file in LAS format (\*.las or \*.laz)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing names of LAS input files  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input files in LAS format (\*.las or \*.laz)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Count of points per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **sum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sum of values of point intensities per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **mean** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean of point intensities per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **proportional_n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map of proportional point count  
    &nbsp;&nbsp;&nbsp;&nbsp;Point count per 3D cell divided by point count per vertical column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **proportional_sum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map of proportional sum of values  
    &nbsp;&nbsp;&nbsp;&nbsp;Sum of values per 3D cell divided by sum of values per vertical column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **return_filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected return type  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, all points are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *first, last, mid*  
    **class_filter** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected class(es)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is comma separated integers. If not specified, all points are imported.  
    **base_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtract raster values from the z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;The scale for z is applied beforehand, the filter afterwards  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale to apply to Z data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **intensity_range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for intensity values (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **intensity_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale to apply to intensity values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *v*, *o*, *p*, *s*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use base raster actual resolution instead of computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only valid points  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Points invalid according to APSRS LAS specification will be filtered out  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print LAS file info and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scan data file for extent then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In scan mode, print using shell script style  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS input file  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input file in LAS format (\*.las or \*.laz)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing names of LAS input files  
    &nbsp;&nbsp;&nbsp;&nbsp;LiDAR input files in LAS format (\*.las or \*.laz)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Count of points per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **sum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sum of values of point intensities per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **mean** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Mean of point intensities per cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **proportional_n** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map of proportional point count  
    &nbsp;&nbsp;&nbsp;&nbsp;Point count per 3D cell divided by point count per vertical column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **proportional_sum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map of proportional sum of values  
    &nbsp;&nbsp;&nbsp;&nbsp;Sum of values per 3D cell divided by sum of values per vertical column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **return_filter** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected return type  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, all points are imported  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *first, last, mid*  
    **class_filter** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Only import points of selected class(es)  
    &nbsp;&nbsp;&nbsp;&nbsp;Input is comma separated integers. If not specified, all points are imported.  
    **base_raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Subtract raster values from the z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;The scale for z is applied beforehand, the filter afterwards  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **zscale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale to apply to Z data  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **intensity_range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter range for intensity values (min,max)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **intensity_scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale to apply to intensity values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *v*, *o*, *p*, *s*, *g*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use base raster actual resolution instead of computational region  
    &nbsp;&nbsp;&nbsp;&nbsp;**v**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use only valid points  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Points invalid according to APSRS LAS specification will be filtered out  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Override projection check (use current projects's CRS)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Assume that the dataset has the same coordinate reference system as the current project  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print LAS file info and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Scan data file for extent then exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;In scan mode, print using shell script style  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The *[r.in.lidar](r.in.lidar.md)* module is very similar to the
*r3.in.lidar* module and many parts of its documentation apply also for
*r3.in.lidar*.

![Proportional count of points per 3D cell](r3_in_lidar.png)
*Figure: Proportional count of points per 3D cell. When 50% of all
points in a vertical column fall into a given 3D cell, the value is 0.5.
Here, the green color was assigned to 0.5, red to 1 and yellow to 0. The
figure shows vertical slices and green color indicates high vegetation
while red color indicates bare ground.*

## NOTES

- This module is new and partially experimental. Please don't rely on
  its interface and be critical towards its outputs. Please report
  issues on the mailing list or in the bug tracker
- No reprojection is performed, you need to reproject ahead or use a
  GRASS project with the coordinate system that matches that of the
  data.
- Some temporary maps are created but not cleaned up. Use of
  **--overwrite** might be necessary even when not desired.
- Expects points to have intensity and causing random (undefined) result
  for related outputs (**sum, mean, proportional_sum**) when the
  intensity is not present but the outputs were requested.

## EXAMPLES

### Basic import of the data

Set the region according to a 2D raster and adding 3D minimum (bottom),
maximum (top) and vertical (top-bottom) resolution.

```sh
g.region rast=secref b=80 t=160 tbres=5 -p3
```

Now, *r3.in.lidar* will create the 3D raster of the size given by the
computation region:

```sh
r3.in.lidar input=points.las n=points_n sum=points_sum \
    mean=points_mean proportional_n=points_n_prop \
    proportional_sum=points_sum_prop
```

### Point density vertical structure reduced to the terrain

Create ground raster:

```sh
r.in.lidar input=points.las output=ground method=mean class_filter=2
```

Set vertical extent of computational region to (relative) coordinates
above ground:

```sh
g.region rast=secref b=0 t=47 -p3
```

Compute point density:

```sh
r3.in.lidar input=points.las n=points_n sum=points_sum \
    mean=points_mean proportional_n=points_n_prop \
    proportional_sum=points_sum_prop \
    base_raster=ground
```

### Complete workflow for vertical structure analysis

Compute the point density of points in 2D while setting the output
extent to be based on the data (**-e**) and the resolution set to a
relatively high number (here 10 map units, i.e. meters for metric
projections).

```sh
r.in.lidar input=points.las output=points_n method=n -e resolution=10
```

This step can be repeated with using different resolutions (and the
**--overwrite** flag) to determine the resolution for the further
analysis.

The **class_filter** option should be also provided if only part of the
points is analyzed, for example `class_filter=3,4,5` would be used for
low, medium, and high vegetation if the LAS file follows the
usedstandard ASPRS class numbers.

The resolution should be suitable for computing digital elevation model
which will be computed in the next steps. Once you decided on the
resolution, you can use the 2D raster to set the computational region
extent and resolution:

```sh
g.region raster=points_n -p3
```

`class_filter=2` is used to limit

```sh
r.in.lidar input=points.las output=ground_mean method=mean class_filter=2
```

The following steps are not necessary if the point density is high
enough to fill the raster continuously.

Convert the raster to vector point resulting in a decimated point cloud:

```sh
v.to.rast input=ground_mean type=point output=ground_decimated use=z
```

Interpolate the ground surface from the decimated ground points:

```sh
v.surf.rst input=ground_decimated elevation=ground
```

Now we need to determine upper vertical limit for the 3D raster (the top
value from `g.region -p3`). This can be potentially done with lower
resolution. The **-d** flag ensures that the ground raster will be used
in its actual resolution regardless of the resolution of the output.

```sh
r.in.lidar input=points.las method=max output=veg_max class_filter=3,4,5 base_raster=ground -d
```

With that, we can finally set up the 3D extent and resolution:

```sh
g.region rast=secref b=0 t=40 res=1 res3=1 -p3
```

Note that the 2D and 3D resolutions are separate so that user can
perform the 2D calculations on a finer resolution than the 3D
calculations. The vertical resolution can be and often is set to a
different value as well. Here we use the same value for all resolutions
for simplicity.

Finally, we perform the 3D binning where we count number of points per
cell (voxel):

```sh
r3.in.lidar input=points.las n=n class_filter=3,4,5 base_raster=ground -d
```

## REFERENCES

- V. Petras, A. Petrasova, J. Jeziorska, H. Mitasova (2016): *Processing
  UAV and lidar point clouds in GRASS GIS*. XXIII ISPRS Congress 2016
  \[[ISPRS
  Archives](https://doi.org/10.5194/isprs-archives-XLI-B7-945-2016),
  [ResearchGate](https://www.researchgate.net/publication/304340172_Processing_UAV_and_lidar_point_clouds_in_GRASS_GIS)\]
- [ASPRS LAS
  format](https://www.asprs.org/committee-general/laser-las-file-format-exchange-activities.html)
- [LAS library](https://liblas.org/)
- [LAS library C API](https://liblas.org/doxygen/liblas_8h.html)
  documentation

## SEE ALSO

*[r3.in.xyz](r3.in.xyz.md), [r.in.lidar](r.in.lidar.md),
[v.in.lidar](v.in.lidar.md), [r.to.rast3](r.to.rast3.md),
[r3.to.rast](r3.to.rast.md), [r3.mapcalc](r3.mapcalc.md),
[g.region](g.region.md)*

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r3.in.lidar source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.in.lidar)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.in.lidar))  
Latest change: Wednesday Mar 05 14:10:57 2025 in commit [8605efe](https://github.com/OSGeo/grass/commit/8605efeb76f1112df8cc657220ce4e1f1c1b94f3)
