---
name: r3.what
description: Queries 3D raster in specified 2D or 3D coordinates.
keywords: [ raster3d, query, voxel ]
---

# r3.what

Queries 3D raster in specified 2D or 3D coordinates.

=== "Command line"

    **r3.what**
    [**-mz**]
    **input**=*name*
    [**coordinates**=*east,north* [,*east,north*,...]]
    [**coordinates_3d**=*east,north,top* [,*east,north,top*,...]]
    [**points**=*name*]
    [**output**=*name*]
    [**separator**=*character*]
    [**null_value**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.what input=name coordinates=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.what***",
        **input**,
        **coordinates**=*None*,
        **coordinates_3d**=*None*,
        **points**=*None*,
        **output**=*None*,
        **separator**=*"pipe"*,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.what", input="name", coordinates=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_what*(**input**,
        **coordinates**=*None*,
        **coordinates_3d**=*None*,
        **points**=*None*,
        **output**=*None*,
        **separator**=*"pipe"*,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_what(input="name", coordinates=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input 3D raster map  
    **coordinates**=*east,north* [,*east,north*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Query with 2D coordinates  
    **coordinates_3d**=*east,north,top* [,*east,north,top*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Query with 3D coordinates  
    **points**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for query  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore points Z values  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query with 2D coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **coordinates_3d** : list[tuple[float, float, float]] | tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query with 3D coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north,top*  
    **points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for query  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore points Z values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster_3d, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query with 2D coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **coordinates_3d** : list[tuple[float, float, float]] | tuple[float, float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Query with 3D coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north,top*  
    **points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for query  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String representing NULL value  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use 3D raster mask (if exists) with input map  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore points Z values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.what* queries 3D raster at specified coordinates. The *input*
parameter is a valid 3D raster map in the current mapset search path.
The *output* parameter is used to output results in a text file. If
*output* is not specified or '-' is used, then standard output (stdout)
is used.

Coordinates can be specified directly using options **coordinates** as
coordinate pairs (east, north), or using option **coordinates\_3d** as
east, north and top. If the coordinates are 2D, the result will be a
list of values representing the vertical column of the 3D raster at that
coordinates (from bottom to top). If 3D coordinates are provided only
one value is returned. User can specify multiple coordinates.

Another option is to specify vector points map using option **points**.
It can be either 2D or 3D. If a 3D vector points map is specified, one
3D raster value per point is printed. If that is not desired, flag **z**
will ignore the z coordinate and the module returns values for the
vertical column.

## Example

We create a 3D raster where values depend on the depth. We query the 3D
raster with two 2D coordinates:

```sh
g.region s=0 n=100 w=0 e=100 b=0 t=100 res3=1 res=1 tbres=10 -p3
r3.mapcalc "new = depth()"
r3.what input=new@user1 coordinates=10,20,50,50
```

```text
10.000000|20.000000|1.000000|2.000000|3.000000|4.000000|5.000000|6.000000|7.000000|8.000000|9.000000|10.000000
50.000000|50.000000|1.000000|2.000000|3.000000|4.000000|5.000000|6.000000|7.000000|8.000000|9.000000|10.000000
```

Here we query the 3D raster with two 3D coordinates:

```sh
r3.what input=new@user1 coordinates_3d=10,10,1,10,10,11
```

```text
10.000000|10.000000|1.000000|1.000000
10.000000|10.000000|11.000000|2.000000
```

## SEE ALSO

*[r.what](https://grass.osgeo.org/grass-stable/manuals/r.what.html),
[r3.out.ascii](https://grass.osgeo.org/grass-stable/manuals/r3.out.ascii.html),
[v.what.rast3](https://grass.osgeo.org/grass-stable/manuals/v.what.rast3.html),
[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html)*

## AUTHOR

Anna Petrasova, NCSU GeoForAll Lab

## SOURCE CODE

Available at: [r3.what source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster3d/r3.what)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster3d/r3.what))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
