---
name: t.vect.extract.py
description: Extracts a subset of a space time vector dataset.
keywords: [ temporal, extract, vector, time ]
---

# t.vect.extract.py

Extracts a subset of a space time vector dataset.

=== "Command line"

    **t.vect.extract.py**
    [**-n**]
    **input**=*name*
    [**where**=*sql_query*]
    [**expression**=*sql_query*]
    **output**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    [**basename**=*string*]
    [**suffix**=*name*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.vect.extract.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.vect.extract.py***",
        **input**,
        **where**=*None*,
        **expression**=*None*,
        **output**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area"*,
        **basename**=*None*,
        **suffix**=*"gran"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.vect.extract.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_vect_extract_py*(**input**,
        **where**=*None*,
        **expression**=*None*,
        **output**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area"*,
        **basename**=*None*,
        **suffix**=*"gran"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_vect_extract_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **expression**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area*  
    **basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %%05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of v.extract processes to run in parallel. Use only if database backend is used which supports concurrent writing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Register empty maps  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **expression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stvds, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %%05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of v.extract processes to run in parallel. Use only if database backend is used which supports concurrent writing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register empty maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **expression** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stvds, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'num' for numerical suffix with a specific number of digits (default %%05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of v.extract processes to run in parallel. Use only if database backend is used which supports concurrent writing  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register empty maps  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The purpose of **t.vect.extract** is to extract a subset of a space time
vector dataset and to store that subset in a different space time vector
dataset.

## EXAMPLE

In the following example a new space time vector dataset will be create
with all the data later than the year 2000:

```sh
t.vect.extract input=shoreline where="start_time > 2000" \
               output=shoreline_later_2000 basename=new_shoreline

t.info shoreline_later_2000@shoreline type=stvds
 +-------------------- Space Time Vector Dataset -----------------------------+
 |                                                                            |
 +-------------------- Basic information -------------------------------------+
 | Id: ........................ shoreline_later_2000@shoreline
 | Name: ...................... shoreline_later_2000
 | Mapset: .................... shoreline
 | Creator: ................... lucadelu
 | Temporal type: ............. relative
 | Creation time: ............. 2014-11-29 08:43:50.043219
 | Modification time:.......... 2014-11-29 08:43:50.085407
 | Semantic type:.............. mean
 +-------------------- Relative time -----------------------------------------+
 | Start time:................. 2003
 | End time:................... 2009
 | Relative time unit:......... years
 | Granularity:................ 1
 | Temporal type of maps:...... point
 +-------------------- Spatial extent ----------------------------------------+
 | North:...................... 1039175.31479
 | South:...................... 34705.216018
 | East:.. .................... 3052322.44671
 | West:....................... 2130004.16779
 | Top:........................ 0.0
 | Bottom:..................... 0.0
 +-------------------- Metadata information ----------------------------------+
 | Vector register table:...... vector_map_register_8395740fc8de42149fef74a3d25bbb05
 | Number of points ........... 0
 | Number of lines ............ 407
 | Number of boundaries ....... 0
 | Number of centroids ........ 0
 | Number of faces ............ 0
 | Number of kernels .......... 0
 | Number of primitives ....... 407
 | Number of nodes ............ 767
 | Number of areas ............ 0
 | Number of islands .......... 0
 | Number of holes ............ 0
 | Number of volumes .......... 0
 | Number of registered maps:.. 3
 |
 | Title:
 | North Carolina shoreline
 | Description:
 | North Caroline shoreline from 2000 to 2009
 | Command history:
 | # 2014-11-29 08:43:50
 | t.vect.extract input="shoreline"
 |     where="start_time > 2000" output="shoreline_later_2000"
 |     basename="new_shoreline"
 | # 2014-11-29 08:44:14
 | t.support type="stvds"
 |     input="shoreline_later_2000@shoreline"
 |     descr="North Caroline shoreline from 2000 to 2009"
 +----------------------------------------------------------------------------+

t.vect.list shoreline_later_2000
name|layer|mapset|start_time|end_time
shoreline_2003|None|shoreline|2003|None
shoreline_2004|None|shoreline|2004|None
shoreline_2009|None|shoreline|2009|None
```

## SEE ALSO

*[t.create](t.create.md), [t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.vect.extract source code](https://github.com/OSGeo/grass/tree/main/temporal/t.vect.extract)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.vect.extract))  
Latest change: Tuesday Jan 27 12:40:13 2026 in commit [5e8b13d](https://github.com/OSGeo/grass/commit/5e8b13d47dd4fc81efa5abefe90c34f7a8291fb9)
