---
name: t.vect.what.strds.py
description: Stores raster map values at spatial and temporal positions of vector points as vector attributes.
keywords: [ temporal, sampling, vector, time ]
---

# t.vect.what.strds.py

Stores raster map values at spatial and temporal positions of vector points as vector attributes.

=== "Command line"

    **t.vect.what.strds.py**
    **input**=*name*
    **strds**=*name*
    [**column**=*string*]
    **method**=*string*
    [**where**=*sql_query*]
    [**t_where**=*sql_query*]
    [**sampling**=*name* [,*name*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.vect.what.strds.py input=name strds=name method=disabled
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.vect.what.strds.py***",
        **input**,
        **strds**,
        **column**=*None*,
        **method**=*"disabled"*,
        **where**=*None*,
        **t_where**=*None*,
        **sampling**=*"start"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.vect.what.strds.py", input="name", strds="name", method="disabled")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_vect_what_strds_py*(**input**,
        **strds**,
        **column**=*None*,
        **method**=*"disabled"*,
        **where**=*None*,
        **t_where**=*None*,
        **sampling**=*"start"*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_vect_what_strds_py(input="name", strds="name", method="disabled")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    **strds**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **column**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector column to be created and to store sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;The use of a column name forces t.vect.what.rast to sample only values from the first map found in an interval. Otherwise the raster map names are used as column names  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *disabled, average, count, median, mode, minimum, min_raster, maximum, max_raster, stddev, range, sum, variance, diversity, slope, offset, detcoeff, quart1, quart3, perc90, quantile, skewness, kurtosis*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *disabled*  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **t_where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    **sampling**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;The method to be used for sampling the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *start, during, overlap, contain, equal, follows, precedes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **strds** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector column to be created and to store sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;The use of a column name forces t.vect.what.rast to sample only values from the first map found in an interval. Otherwise the raster map names are used as column names  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *disabled, average, count, median, mode, minimum, min_raster, maximum, max_raster, stddev, range, sum, variance, diversity, slope, offset, detcoeff, quart1, quart3, perc90, quantile, skewness, kurtosis*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *disabled*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **t_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **sampling** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The method to be used for sampling the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *start, during, overlap, contain, equal, follows, precedes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time vector dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stvds, *name*  
    **strds** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the vector column to be created and to store sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;The use of a column name forces t.vect.what.rast to sample only values from the first map found in an interval. Otherwise the raster map names are used as column names  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *disabled, average, count, median, mode, minimum, min_raster, maximum, max_raster, stddev, range, sum, variance, diversity, slope, offset, detcoeff, quart1, quart3, perc90, quantile, skewness, kurtosis*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *disabled*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **t_where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword used in the temporal GIS framework  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: start_time &gt; '2001-01-01 12:30:00'  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *sql_query*  
    **sampling** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The method to be used for sampling the input dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *start, during, overlap, contain, equal, follows, precedes*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *start*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The module *t.vect.what.strds* samples a space time raster dataset
(STRDS) at the spatio-temporal locations of a space time vector dataset
(STVDS).

## EXAMPLE

The example is based on the space time vector dataset
"precip_stations@climate_2009_2012" created in the
[t.vect.observe.strds](t.vect.observe.strds.md) example. In the example
below, the module fills the new column "new_temp" with values extracted
from the "tempmean_monthly" space time raster dataset:

```sh
t.vect.what.strds input=precip_stations@climate_2009_2012 \
                  strds=tempmean_monthly@climate_2009_2012 \
                  column=new_temp method=average
```

## SEE ALSO

*[r.univar](r.univar.md), [v.univar](v.univar.md),
[v.what.rast](v.what.rast.md), [v.what.rast3](v.what.rast3.md),
[v.what.strds](v.what.strds.md), [v.what.vect](v.what.vect.md),
[t.create](t.create.md), [t.info](t.info.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.vect.what.strds source code](https://github.com/OSGeo/grass/tree/main/temporal/t.vect.what.strds)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.vect.what.strds))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
