---
hide:
  - toc
---

# Topic: algebra

| Tool | Description |
|--------|-------------|
| [r.mapcalc](r.mapcalc.md) | Raster map calculator. |
| [r.mapcalc.simple](r.mapcalc.simple.md) | Calculates a new raster map from a simple r.mapcalc expression. |
| [r.mfilter](r.mfilter.md) | Performs raster map matrix filter. |
| [r.neighbors](r.neighbors.md) | Makes each cell category value a function of the category values assigned to the cells around it, and stores new cell values in an output raster map layer. |
| [r.quantile](r.quantile.md) | Compute quantiles using two passes. |
| [r.texture](r.texture.md) | Generate images with textural features from a raster map. |
| [r3.mapcalc](r3.mapcalc.md) | Raster map calculator. |
| [r3.neighbors](r3.neighbors.md) | Makes each voxel value a function of the values assigned to the voxels around it, and stores new voxel values in an output 3D raster map |
| [t.rast.algebra](t.rast.algebra.md) | Apply temporal and spatial operations on space time raster datasets using temporal raster algebra. |
| [t.rast.mapcalc](t.rast.mapcalc.md) | Performs spatio-temporal mapcalc expressions on temporally sampled maps of space time raster datasets. |
| [t.rast3d.algebra](t.rast3d.algebra.md) | Apply temporal and spatial operations on space time 3D raster datasets using temporal 3D raster algebra. |
| [t.rast3d.mapcalc](t.rast3d.mapcalc.md) | Performs r3.mapcalc expressions on maps of sampled space time 3D raster datasets. |
| [t.vect.algebra](t.vect.algebra.md) | Apply temporal and spatial operations on space time vector datasets using temporal vector algebra. |
| [v.neighbors](v.neighbors.md) | Neighborhood analysis tool for vector point maps. Makes each cell value a function of the attribute values assigned to the vector points or centroids in a radius around it, and stores new cell values in an output raster map. |

*See also the corresponding keyword for additional references:*

<!-- topic_keyword { include: [algebra] } -->
