---
name: v.build.pg.py
description: Builds PostGIS topology for vector map linked via v.external.
keywords: [ vector, external, PostGIS, topology ]
---

# v.build.pg.py

Builds PostGIS topology for vector map linked via v.external.

=== "Command line"

    **v.build.pg.py**
    [**-p**]
    **map**=*name*
    [**topo_schema**=*name*]
    **topo_column**=*name*
    [**tolerance**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.build.pg.py map=name topo_column=topo
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.build.pg.py***",
        **map**,
        **topo_schema**=*None*,
        **topo_column**=*"topo"*,
        **tolerance**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.build.pg.py", map="name", topo_column="topo")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_build_pg_py*(**map**,
        **topo_schema**=*None*,
        **topo_column**=*"topo"*,
        **tolerance**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_build_pg_py(map="name", topo_column="topo")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    **topo_schema**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of schema where to build PostGIS topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: topo_&lt;map&gt;  
    **topo_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of topology column  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *topo*  
    **tolerance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance to snap input geometry to existing primitives  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Don't execute SQL statements, just print them and exit  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **topo_schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of schema where to build PostGIS topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: topo_&lt;map&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **topo_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of topology column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *topo*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance to snap input geometry to existing primitives  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't execute SQL statements, just print them and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **topo_schema** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of schema where to build PostGIS topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: topo_&lt;map&gt;  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    **topo_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of topology column  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *topo*  
    **tolerance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tolerance to snap input geometry to existing primitives  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Don't execute SQL statements, just print them and exit  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.build.pg* builds PostGIS topology for feature tables linked via
*[v.external](https://grass.osgeo.org/grass-stable/manuals/v.external.html)*.

## NOTES

Note that [PostGIS
Topology](https://trac.osgeo.org/postgis/wiki/UsersWikiPostgisTopology)
extension is currently under development. *v.build.pg* requires
**PostGIS 2.0.0+**.

Existing PostGIS topology schema can be overwrite by **--overwrite**
flag.

*v.build.pg* calls PostGIS functions:

1. [CreateTopology()](https://www.postgis.net/docs/manual-dev/CreateTopology.html)
    to create topology schema in the database,
2. [AddTopoGeometryColumn()](https://www.postgis.net/docs/manual-dev/AddTopoGeometryColumn.html)
    to add a topogeometry column to an existing feature table, and
3. [toTopoGeom()](https://www.postgis.net/docs/manual-dev/toTopoGeom.html)
    to create a new topo geometry from the simple feature geometry.

## EXAMPLES

### Workflow example

Export vector map into PostGIS:

```sh
v.out.ogr input=bridges output=PG:dbname=pgis_nc format=PostgreSQL
```

Create a new vector map as a link to PostGIS table:

```sh
v.external input=PG:dbname=pgis_nc layer=bridges
```

Check metadata:

```sh
v.info map=bridges

...
 |----------------------------------------------------------------------------|
 | Map format:      PostGIS (PostgreSQL)                                      |
 | DB table:        public.bridges                                            |
 | DB name:         pgis_nc                                                   |
 | Geometry column: wkb_geometry                                              |
 | Feature type:    point                                                     |
 |----------------------------------------------------------------------------|
...
```

Build PostGIS topology for the link:

```sh
v.build.pg map=bridges

...
Topology topo_bridges (6), SRID 900914, precision 1
10938 nodes, 0 edges, 0 faces, 10938 topogeoms in 1 layers
Layer 1, type Puntal (1), 10938 topogeoms
 Deploy: public.bridges.topo
...
```

### Dry run

For testing issues use **-p** flag.

```sh
v.build.pg map=bridges

Creating new topology schema...

SELECT topology.createtopology('topo_bridges', \
find_srid('public', 'bridges', 'wkb_geometry'), 1)

Adding new topology column...

SELECT topology.AddTopoGeometryColumn('topo_bridges', \
'public', 'bridges', 'topo', 'point')

Building PostGIS topology...

UPDATE bridges SET topo = topology.toTopoGeom(wkb_geometry, \
'topo_bridges', 1, 1)


SELECT topology.TopologySummary('topo_bridges')
```

## SEE ALSO

*[v.external](https://grass.osgeo.org/grass-stable/manuals/v.external.html),
[v.out.ogr](https://grass.osgeo.org/grass-stable/manuals/v.out.ogr.html),
[v.out.postgis](https://grass.osgeo.org/grass-stable/manuals/v.out.postgis.html),
[v.build](https://grass.osgeo.org/grass-stable/manuals/v.build.html)*

## AUTHOR

Martin Landa, Czech Technical University in Prague, Czech Republic

## SOURCE CODE

Available at: [v.build.pg source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.build.pg)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.build.pg))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
