---
name: v.convert.all.py
description: Converts all older versions of GRASS vector maps in current mapset to current format.
keywords: [ vector, import, conversion ]
---

# v.convert.all.py

Converts all older versions of GRASS vector maps in current mapset to current format.

=== "Command line"

    **v.convert.all.py**
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.convert.all.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.convert.all.py***",
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.convert.all.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_convert_all_py*(        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_convert_all_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.convert.all* converts all GRASS 5.0/5.3/5.4 vectors in the current
mapset into GRASS 7 vectors.

## NOTES

Vector maps from 5.0/5.3/5.4 and 7 do not interfere. They are stored in
different directories, so the same names can be kept. Old vector maps
can be listed with *g.list oldvect*.

To convert back from 7 to 6 vector format, use *v.build* in GRASS 6.

To convert back from 6.0 into the 5.0/5.3/5.4 vector format, use
*v.out.ogr* (to SHAPE format) and then *v.in.shape* in the old GRASS
program.

As this GRASS version uses SQL for attribute management, there are some
[SQL restrictings concerning the file names](sql.md). This script
changes dots (e.g. "foo.bar") in old vector map names into underline(s)
(e.g. "foo\_bar").

## EXAMPLE

To convert all old vector maps in the current mapset to the new vector
format:

```sh
v.convert.all
```

## SEE ALSO

*[g.list](https://grass.osgeo.org/grass-stable/manuals/g.list.html),
[v.convert](https://grass.osgeo.org/grass-stable/manuals/v.convert.html),
[v.out.ascii](https://grass.osgeo.org/grass-stable/manuals/v.out.ascii.html),
[v.out.ogr](https://grass.osgeo.org/grass-stable/manuals/v.out.ogr.html)*

## AUTHOR

Markus Neteler, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [v.convert.all source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.convert.all)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.convert.all))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
