---
name: v.gsflow.export.py
description: Export databse tables and pour point for GSFLOW input and control files
keywords: [ vector, stream network, hydrology, GSFLOW ]
---

# v.gsflow.export.py

Export databse tables and pour point for GSFLOW input and control files

=== "Command line"

    **v.gsflow.export.py**
    [**reaches_input**=*name*]
    [**segments_input**=*name*]
    [**gravres_input**=*name*]
    [**hru_input**=*name*]
    [**pour_point_input**=*name*]
    [**bc_cell_input**=*name*]
    [**reaches_output**=*name*]
    [**segments_output**=*name*]
    [**gravres_output**=*name*]
    [**hru_output**=*name*]
    [**pour_point_boundary_output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.gsflow.export.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.gsflow.export.py***",
        **reaches_input**=*None*,
        **segments_input**=*None*,
        **gravres_input**=*None*,
        **hru_input**=*None*,
        **pour_point_input**=*None*,
        **bc_cell_input**=*None*,
        **reaches_output**=*None*,
        **segments_output**=*None*,
        **gravres_output**=*None*,
        **hru_output**=*None*,
        **pour_point_boundary_output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.gsflow.export.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_gsflow_export_py*(**reaches_input**=*None*,
        **segments_input**=*None*,
        **gravres_input**=*None*,
        **hru_input**=*None*,
        **pour_point_input**=*None*,
        **bc_cell_input**=*None*,
        **reaches_output**=*None*,
        **segments_output**=*None*,
        **gravres_output**=*None*,
        **hru_output**=*None*,
        **pour_point_boundary_output**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_gsflow_export_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **reaches_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches where stream segments overlap MODFLOW grid cells  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **segments_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream segments, coincident with HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **gravres_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Union of MODFLOW grid and HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **hru_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;PRMS-style hydrologic response units  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **pour_point_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point at the outlet of the basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **bc_cell_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary condition cell downstream of pour point  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **reaches_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **segments_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segments table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **gravres_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Gravity Reservoir output table for GSFLOW input, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **hru_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;HRU table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **pour_point_boundary_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point and b.c. coordinates for GSFLOW input, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **reaches_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches where stream segments overlap MODFLOW grid cells  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **segments_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream segments, coincident with HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **gravres_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Union of MODFLOW grid and HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **hru_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;PRMS-style hydrologic response units  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **pour_point_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point at the outlet of the basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **bc_cell_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary condition cell downstream of pour point  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **reaches_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **segments_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segments table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **gravres_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Gravity Reservoir output table for GSFLOW input, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **hru_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;HRU table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **pour_point_boundary_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point and b.c. coordinates for GSFLOW input, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **reaches_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches where stream segments overlap MODFLOW grid cells  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **segments_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream segments, coincident with HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **gravres_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Union of MODFLOW grid and HRUs  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **hru_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;PRMS-style hydrologic response units  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **pour_point_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point at the outlet of the basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **bc_cell_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Boundary condition cell downstream of pour point  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **reaches_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Reaches table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **segments_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segments table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **gravres_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Gravity Reservoir output table for GSFLOW input, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **hru_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;HRU table, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **pour_point_boundary_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point and b.c. coordinates for GSFLOW input, no file ext  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.gsflow.export* produces output tables and maps that are used for the
USGS combined groundwater (MODFLOW) and surface-water (PRMS) model
GSFLOW. These are read in through a sequence of ["GSFLOW pre-processor"
scripts available at the University of Minnesota's Hydro GitHub
page](https://github.com/UMN-Hydro/GSFLOW_pre-processor).

## NOTES

These outputs comprise many ASCII files that are read in by GSFLOW.

## REFERENCES

Ng, G.-H. C., A. D. Wickert, R. L. McLaughlin, J. La Frenierre, S.
Liess, and L. Sabeeri (2016), Modeling the role of groundwater and
vegetation in the hydrological response of tropical glaciated watersheds
to climate change, in AGU Fall Meeting Abstracts, H13L–1590, San
Francisco, CA.

## SEE ALSO

*[v.gsflow.gravres](v.gsflow.gravres.md),
[v.gsflow.grid](v.gsflow.grid.md),
[v.gsflow.hruparams](v.gsflow.hruparams.md),
[v.gsflow.reaches](v.gsflow.reaches.md),
[v.gsflow.segments](v.gsflow.segments.md),
[v.gsflow.mapdata](v.gsflow.mapdata.md),
[v.stream.inbasin](v.stream.inbasin.md),
[v.stream.network](v.stream.network.md)*

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.gsflow.export source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.gsflow.export)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.gsflow.export))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
