---
name: v.gsflow.mapdata.py
description: Upload data to PRMS data
keywords: [ vector, import, hydrology, GSFLOW ]
---

# v.gsflow.mapdata.py

Upload data to PRMS data

=== "Command line"

    **v.gsflow.mapdata.py**
    **map**=*name*
    [**vector_area**=*name*]
    [**vector_points**=*name*]
    [**raster**=*name*]
    [**dxy**=*string*]
    [**column**=*string*]
    [**from_column**=*string*]
    [**attrtype**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.gsflow.mapdata.py map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.gsflow.mapdata.py***",
        **map**,
        **vector_area**=*None*,
        **vector_points**=*None*,
        **raster**=*None*,
        **dxy**=*"100"*,
        **column**=*None*,
        **from_column**=*None*,
        **attrtype**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.gsflow.mapdata.py", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_gsflow_mapdata_py*(**map**,
        **vector_area**=*None*,
        **vector_points**=*None*,
        **raster**=*None*,
        **dxy**=*"100"*,
        **column**=*None*,
        **from_column**=*None*,
        **attrtype**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_gsflow_mapdata_py(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;GSFLOW vect: HRUs, MODFLOW grid, gravres, segments, or reaches  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **vector_area**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector area (polygon) data set (e.g., geologic map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **vector_points**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector points data set (e.g., field surveys at points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **raster**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster gridded data set (e.g., gridded soils data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **dxy**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size for rasterization of vector_area, if needed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **column**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column to which to upload data (will create if doesn't exist)  
    **from_column**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column from which to upload data (for vector input)  
    **attrtype**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type in column; user may treat int as float  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, float, string*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;GSFLOW vect: HRUs, MODFLOW grid, gravres, segments, or reaches  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vector_area** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector area (polygon) data set (e.g., geologic map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vector_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector points data set (e.g., field surveys at points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster gridded data set (e.g., gridded soils data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dxy** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size for rasterization of vector_area, if needed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column to which to upload data (will create if doesn't exist)  
    **from_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column from which to upload data (for vector input)  
    **attrtype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type in column; user may treat int as float  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, float, string*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;GSFLOW vect: HRUs, MODFLOW grid, gravres, segments, or reaches  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vector_area** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector area (polygon) data set (e.g., geologic map)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **vector_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector points data set (e.g., field surveys at points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster gridded data set (e.g., gridded soils data)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dxy** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size for rasterization of vector_area, if needed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column to which to upload data (will create if doesn't exist)  
    **from_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column from which to upload data (for vector input)  
    **attrtype** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type in column; user may treat int as float  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *int, float, string*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.gsflow.mapdata* allows the user to add attributes from any raster or
vector (area or point) data set to a GSFLOW set of HRUs, MODFLOW grid
cells, gravity reservoirs, stream segments, or stream reaches. It does
so by using either an averaging or a nearest-neighbor approach,
depending on the type of both the data source geometry (raster, vector
area, vector point) and, if it is a vector, the data source in the
column (integer, string (varchar), or float (double precision)).  
Nearest-neighbor
([v.distance](https://grass.osgeo.org/grass-stable/manuals/v.distance.html),)
is used for:  
Vector point data  
Vector area data in which the data type in the column that is queried is
integer or varchar  
An average
([v.rast.stats](https://grass.osgeo.org/grass-stable/manuals/v.rast.stats.html),)
is used for:  
Raster data  
Vector area data with data in the column that is queried that is of
"double precision" type  

## SEE ALSO

*[v.gsflow.export](v.gsflow.export),
[v.gsflow.gravres](v.gsflow.gravres), [v.gsflow.grid](v.gsflow.grid),
[v.gsflow.hruparams](v.gsflow.hruparams.md),
[v.gsflow.reaches](v.gsflow.reaches.md),
[v.gsflow.segments](v.gsflow.segments.md),
[r.gsflow.hydrodem](r.gsflow.hydrodem.md),
[v.stream.inbasin](v.stream.inbasin.md),
[v.stream.network](v.stream.network.md)*

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.gsflow.mapdata source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.gsflow.mapdata)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.gsflow.mapdata))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
