---
name: v.gsflow.segments.py
description: Prepares stream segments for PRMS and GSFLOW
keywords: [ vector, stream network, hydrology, GSFLOW ]
---

# v.gsflow.segments.py

Prepares stream segments for PRMS and GSFLOW

=== "Command line"

    **v.gsflow.segments.py**
    **input**=*name*
    **output**=*name*
    [**icalc**=*integer*]
    [**cdpth**=*float*]
    [**fdpth**=*float*]
    [**awdth**=*float*]
    [**bwdth**=*float*]
    [**iupseg**=*string*]
    [**flow**=*string*]
    [**runoff**=*string*]
    [**etsw**=*string*]
    [**pptsw**=*string*]
    [**roughch_value**=*float*]
    [**roughch_raster**=*string*]
    [**roughch_points**=*string*]
    [**roughch_pt_col**=*string*]
    [**roughbk_value**=*float*]
    [**roughbk_raster**=*string*]
    [**roughbk_points**=*string*]
    [**roughbk_pt_col**=*string*]
    [**width1**=*float*]
    [**width2**=*float*]
    [**width_points**=*string*]
    [**width_points_col**=*string*]
    [**width1**=*float*]
    [**width2**=*float*]
    [**width_points**=*string*]
    [**width_points_col**=*string*]
    [**fp_width_value**=*float*]
    [**fp_width_pts**=*string*]
    [**fp_width_pts_col**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.gsflow.segments.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.gsflow.segments.py***",
        **input**,
        **output**,
        **icalc**=*1*,
        **cdpth**=*0.4*,
        **fdpth**=*0.42*,
        **awdth**=*4*,
        **bwdth**=*0.23*,
        **iupseg**=*"0,0"*,
        **flow**=*"0,0"*,
        **runoff**=*"0,0"*,
        **etsw**=*"0,0"*,
        **pptsw**=*"0,0"*,
        **roughch_value**=*0.035*,
        **roughch_raster**=*None*,
        **roughch_points**=*None*,
        **roughch_pt_col**=*None*,
        **roughbk_value**=*0.06*,
        **roughbk_raster**=*None*,
        **roughbk_points**=*None*,
        **roughbk_pt_col**=*None*,
        **width1**=*5*,
        **width2**=*5*,
        **width_points**=*None*,
        **width_points_col**=*None*,
        **width1**=*5*,
        **width2**=*5*,
        **width_points**=*None*,
        **width_points_col**=*None*,
        **fp_width_value**=*0*,
        **fp_width_pts**=*None*,
        **fp_width_pts_col**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.gsflow.segments.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_gsflow_segments_py*(**input**,
        **output**,
        **icalc**=*1*,
        **cdpth**=*0.4*,
        **fdpth**=*0.42*,
        **awdth**=*4*,
        **bwdth**=*0.23*,
        **iupseg**=*"0,0"*,
        **flow**=*"0,0"*,
        **runoff**=*"0,0"*,
        **etsw**=*"0,0"*,
        **pptsw**=*"0,0"*,
        **roughch_value**=*0.035*,
        **roughch_raster**=*None*,
        **roughch_points**=*None*,
        **roughch_pt_col**=*None*,
        **roughbk_value**=*0.06*,
        **roughbk_raster**=*None*,
        **roughbk_points**=*None*,
        **roughbk_pt_col**=*None*,
        **width1**=*5*,
        **width2**=*5*,
        **width_points**=*None*,
        **width_points_col**=*None*,
        **width1**=*5*,
        **width2**=*5*,
        **width_points**=*None*,
        **width_points_col**=*None*,
        **fp_width_value**=*0*,
        **fp_width_pts**=*None*,
        **fp_width_pts_col**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_gsflow_segments_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector stream network from r.stream.extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Segments: stream segments for GSFLOW / PRMS  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **icalc**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream depth option: 0-const; 1,2-Manning (rect/8-pt); 3-aQ^b  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cdpth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow depth coefficient [meters]; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **fdpth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow depth exponent; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.42*  
    **awdth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow width coefficient [meters]; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **bwdth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow width exponent; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.23*  
    **iupseg**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category of upstream diversion segment (from_cat,to_cat,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **flow**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streamflow entering the upstream-most segs (cat,Q,cat,Q,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **runoff**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Diffuse runoff entering each segment (cat,Q,cat,Q,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **etsw**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direct removal of in-channel water by ET (cat,Q,cat,Q)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **pptsw**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direct precipitation on the stream (cat,Q,cat,Q)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **roughch_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n (single value) for ICALC=1,2  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.035*  
    **roughch_raster**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n raster map for ICALC=1,2  
    **roughch_points**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n vector point meas for ICALC=1,2  
    **roughch_pt_col**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name for in-channel n point measurements  
    **roughbk_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n for ICALC=2  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.06*  
    **roughbk_raster**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n raster map for ICALC=2  
    **roughbk_points**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n vector point meas for ICALC=2  
    **roughbk_pt_col**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name for overbank n point measurements  
    **width1**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width2**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width_points**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect (instead of width1,width2)  
    **width_points_col**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect column  
    **width1**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width2**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width_points**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect (instead of width1,width2)  
    **width_points_col**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect column  
    **fp_width_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width as constant value (ICALC=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **fp_width_pts**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width measurement vector (ICALC=2)  
    **fp_width_pts_col**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width measurement column (ICALC=2)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector stream network from r.stream.extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segments: stream segments for GSFLOW / PRMS  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **icalc** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream depth option: 0-const; 1,2-Manning (rect/8-pt); 3-aQ^b  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cdpth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow depth coefficient [meters]; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **fdpth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow depth exponent; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.42*  
    **awdth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow width coefficient [meters]; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **bwdth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow width exponent; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.23*  
    **iupseg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category of upstream diversion segment (from_cat,to_cat,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **flow** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streamflow entering the upstream-most segs (cat,Q,cat,Q,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **runoff** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Diffuse runoff entering each segment (cat,Q,cat,Q,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **etsw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direct removal of in-channel water by ET (cat,Q,cat,Q)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **pptsw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direct precipitation on the stream (cat,Q,cat,Q)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **roughch_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n (single value) for ICALC=1,2  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.035*  
    **roughch_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n raster map for ICALC=1,2  
    **roughch_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n vector point meas for ICALC=1,2  
    **roughch_pt_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name for in-channel n point measurements  
    **roughbk_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n for ICALC=2  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.06*  
    **roughbk_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n raster map for ICALC=2  
    **roughbk_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n vector point meas for ICALC=2  
    **roughbk_pt_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name for overbank n point measurements  
    **width1** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width2** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect (instead of width1,width2)  
    **width_points_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect column  
    **width1** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width2** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect (instead of width1,width2)  
    **width_points_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect column  
    **fp_width_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width as constant value (ICALC=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **fp_width_pts** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width measurement vector (ICALC=2)  
    **fp_width_pts_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width measurement column (ICALC=2)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector stream network from r.stream.extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Segments: stream segments for GSFLOW / PRMS  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **icalc** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Stream depth option: 0-const; 1,2-Manning (rect/8-pt); 3-aQ^b  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **cdpth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow depth coefficient [meters]; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **fdpth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow depth exponent; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.42*  
    **awdth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow width coefficient [meters]; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **bwdth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow width exponent; used if ICALC=3  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.23*  
    **iupseg** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category of upstream diversion segment (from_cat,to_cat,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **flow** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Streamflow entering the upstream-most segs (cat,Q,cat,Q,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **runoff** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Diffuse runoff entering each segment (cat,Q,cat,Q,...)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **etsw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direct removal of in-channel water by ET (cat,Q,cat,Q)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **pptsw** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Direct precipitation on the stream (cat,Q,cat,Q)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0,0*  
    **roughch_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n (single value) for ICALC=1,2  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.035*  
    **roughch_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n raster map for ICALC=1,2  
    **roughch_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;In-channel Manning's n vector point meas for ICALC=1,2  
    **roughch_pt_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name for in-channel n point measurements  
    **roughbk_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n for ICALC=2  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.06*  
    **roughbk_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n raster map for ICALC=2  
    **roughbk_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overbank Manning's n vector point meas for ICALC=2  
    **roughbk_pt_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name for overbank n point measurements  
    **width1** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width2** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect (instead of width1,width2)  
    **width_points_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect column  
    **width1** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Upstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width2** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Downstream width in segment [m], uniform in watershed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **width_points** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect (instead of width1,width2)  
    **width_points_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Channel width point meas vect column  
    **fp_width_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width as constant value (ICALC=2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **fp_width_pts** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width measurement vector (ICALC=2)  
    **fp_width_pts_col** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floodplain width measurement column (ICALC=2)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.gsflow.segments* produces channel segments that are each one link in
the full drainage network. Each segment also corresponds to a hydrologic
response unit (HRU) in this formulation. These are used for the USGS
combined groundwater (MODFLOW) and surface-water (PRMS) model GSFLOW.

## REFERENCES

Ng, G.-H. C., A. D. Wickert, R. L. McLaughlin, J. La Frenierre, S.
Liess, and L. Sabeeri (2016), Modeling the role of groundwater and
vegetation in the hydrological response of tropical glaciated watersheds
to climate change, in AGU Fall Meeting Abstracts, H13L–1590, San
Francisco, CA.

## SEE ALSO

[v.gsflow.export](v.gsflow.export.md),
[v.gsflow.gravres](v.gsflow.gravres.md),
[v.gsflow.grid](v.gsflow.grid.md),
[v.gsflow.hruparams](v.gsflow.hruparams.md),
[v.gsflow.reaches](v.gsflow.reaches.md),
[v.gsflow.mapdata](v.gsflow.mapdata.md),
[v.stream.inbasin](v.stream.inbasin.md),
[v.stream.network](v.stream.network.md)

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.gsflow.segments source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.gsflow.segments)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.gsflow.segments))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
