---
name: v.in.geopaparazzi.py
description: Imports data from Geopaparazzi database.
keywords: [ vector ]
---

# v.in.geopaparazzi.py

Imports data from Geopaparazzi database.

=== "Command line"

    **v.in.geopaparazzi.py**
    [**-bintz**]
    **database**=*name*
    **basename**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.geopaparazzi.py database=name basename=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.geopaparazzi.py***",
        **database**,
        **basename**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.geopaparazzi.py", database="name", basename="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_geopaparazzi_py*(**database**,
        **basename**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_geopaparazzi_py(database="name", basename="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **database**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input Geopaparazzi database  
    **basename**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output file  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import bookmarks  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import images  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import notes  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import tracks  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create a 3D elements (not for bookmarks)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input Geopaparazzi database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *i*, *n*, *t*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import bookmarks  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import images  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import notes  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import tracks  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a 3D elements (not for bookmarks)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **database** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input Geopaparazzi database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *i*, *n*, *t*, *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import bookmarks  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import images  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import notes  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import tracks  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create a 3D elements (not for bookmarks)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.geopaparazzi* imports all elements saved into Geopaparazzi. The
user can import bookmarks, images (warning for the path to images
depends on Android device), notes (one layer for each category) and
tracks.

## EXAMPLES

To import all the elements in the Geopaparazzi database, use:

```sh
v.in.geopaparazzi -bint database=/path/to/geopaparazzi.db base=mydata
```

To import only the tracks in 3D format

```sh
v.in.geopaparazzi -tz database=/path/to/geopaparazzi.db base=track3d
```

## REFERENCES

[Geopaparazzi](https://www.geopaparazzi.org/)

[Geopaparazzi Tables
schema](http://code.google.com/p/geopaparazzi/wiki/DbTables)

## AUTHOR

Luca Delucchi

## SOURCE CODE

Available at: [v.in.geopaparazzi source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.geopaparazzi)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.geopaparazzi))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
