---
name: v.link.precip.py
description: Links time-windows to vector link map.
keywords: [ vector ]
---

# v.link.precip.py

Links time-windows to vector link map.

=== "Command line"

    **v.link.precip.py**
    [**-capr**]
    **schema**=*string*
    [**time**=*string*]
    **type**=*string* [,*string*,...]
    **vector**=*string* [,*string*,...]
    [**layername**=*string*]
    [**color**=*name*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.link.precip.py schema=string type=links vector=points
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.link.precip.py***",
        **schema**,
        **time**=*None*,
        **type**=*"links"*,
        **vector**=*"points"*,
        **layername**=*None*,
        **color**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.link.precip.py", schema="string", type="links", vector="points")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_link_precip_py*(**schema**,
        **time**=*None*,
        **type**=*"links"*,
        **vector**=*"points"*,
        **layername**=*None*,
        **color**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_link_precip_py(schema="string", type="links", vector="points")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **schema**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set schema name containing timewindows  
    **time**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set time "YYYY-MM-DD H:M:S"  
    **type**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose object type to connect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raingauge,  links*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *links*  
    **vector**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose MV representation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lines,  points*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *points*  
    **layername**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of points layer to connect  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create vector map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create vector maps for all timewin  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print attribut table  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Remove temp file  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **schema** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set schema name containing timewindows  
    **time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set time "YYYY-MM-DD H:M:S"  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose object type to connect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raingauge,  links*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *links*  
    **vector** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose MV representation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lines,  points*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *points*  
    **layername** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of points layer to connect  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *a*, *p*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create vector maps for all timewin  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print attribut table  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove temp file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **schema** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set schema name containing timewindows  
    **time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set time "YYYY-MM-DD H:M:S"  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose object type to connect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raingauge,  links*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *links*  
    **vector** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose MV representation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *lines,  points*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *points*  
    **layername** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of points layer to connect  
    **color** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set color table  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *a*, *p*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create vector maps for all timewin  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print attribut table  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Remove temp file  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

## AUTHOR

Matej Krejci, Czech Technical University in Prague, Czech Republic

## SOURCE CODE

Available at: [v.link.precip source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.link.precip)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.link.precip))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
