---
name: v.lrs.where
description: Finds line id and real km+offset for given points in vector map using linear reference system.
keywords: [ vector, linear reference system, network ]
---

# v.lrs.where

Finds line id and real km+offset for given points in vector map using linear reference system.

=== "Command line"

    **v.lrs.where**
    **lines**=*name*
    **points**=*name*
    [**llayer**=*string*]
    [**player**=*string*]
    [**rsdriver**=*string*]
    [**rsdatabase**=*string*]
    **rstable**=*string*
    [**threshold**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.lrs.where lines=name points=name rstable=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.lrs.where***",
        **lines**,
        **points**,
        **llayer**=*"1"*,
        **player**=*"1"*,
        **rsdriver**=*"sqlite"*,
        **rsdatabase**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **rstable**,
        **threshold**=*1000*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.lrs.where", lines="name", points="name", rstable="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_lrs_where*(**lines**,
        **points**,
        **llayer**=*"1"*,
        **player**=*"1"*,
        **rsdriver**=*"sqlite"*,
        **rsdatabase**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **rstable**,
        **threshold**=*1000*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_lrs_where(lines="name", points="name", rstable="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **lines**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    **points**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing points  
    **llayer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **player**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance to nearest line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **lines** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **llayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **player** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance to nearest line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **lines** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector map containing points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **llayer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Line layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **player** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **rsdriver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Driver name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **rsdatabase** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Database name for reference system table  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **rstable** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the reference system table  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance to nearest line  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1000*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.lrs.where* identifies line id and real milepost+offset for points in
vector map using linear reference system.

## EXAMPLE

This example is written for the Spearfish dataset (it continues the
example from *v.lrs.create*).

In this example, the 'route_lrs' shall be queried for unknown positions
(points, stored in the map *newpoints*) along the LRS:

```sh
# generate query points
echo "590866.15|4926737.0
590933|4927133" | v.in.ascii out=newpoints

v.lrs.where lines=route_lrs points=newpoints rstable=route_lrs
pcat|lid|mpost|offset
pcat|lid|mpost|offset
1|22|4.000000+212.091461
2|22|6.000000+188.112093

# verification
g.region vector=route_lrs n=n+100 s=s-100 -p
d.erase
d.vect route_lrs
d.vect busstops disp=attr attr=cat size=10 bg=white lcol=blue yref=bottom
d.vect busstops icon=basic/circle fcol=blue
d.vect newpoints col=red

# measure distance to previous bus stop:
# use measuring tool in graphical user interface
```

## SEE ALSO

*[v.lrs.where](v.lrs.create.md), [v.lrs.segment](v.lrs.segment.md),
[v.lrs.label](v.lrs.label.md)*

*[LRS tutorial](lrs.md),  
[Introducing the Linear Reference System in
GRASS](https://foss4g.asia/2004/Full-Paper_PDF/Introducing-the-Linear-Reference-System-in-GRASS.pdf)*

## AUTHORS

Radim Blazek, ITC-irst/MPA Solutions  
Documentation update (based on above journal article and available
fragments): Markus Neteler

## SOURCE CODE

Available at: [v.lrs.where source code](https://github.com/OSGeo/grass/tree/main/vector/v.lrs/v.lrs.where)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.lrs/v.lrs.where))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
