---
name: v.neighbors
description: Neighborhood analysis tool for vector point maps. Makes each cell value a function of the attribute values assigned to the vector points or centroids in a radius around it, and stores new cell values in an output raster map.
keywords: [ vector, algebra, statistics, raster, aggregation ]
---

# v.neighbors

Neighborhood analysis tool for vector point maps.

Makes each cell value a function of the attribute values assigned to the vector points or centroids in a radius around it, and stores new cell values in an output raster map.

=== "Command line"

    **v.neighbors**
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    **method**=*string*
    **size**=*float*
    [**points_column**=*name*]
    [**cats**=*range*]
    [**where**=*sql_query*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.neighbors input=name output=name method=count size=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.neighbors***",
        **input**,
        **layer**=*"1"*,
        **output**,
        **method**=*"count"*,
        **size**,
        **points_column**=*None*,
        **cats**=*None*,
        **where**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.neighbors", input="name", output="name", method="count", size=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_neighbors*(**input**,
        **layer**=*"1"*,
        **output**,
        **method**=*"count"*,
        **size**,
        **points_column**=*None*,
        **cats**=*None*,
        **where**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_neighbors(input="name", output="name", method="count", size=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for aggregate statistics (count if non given)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *count, sum, average, median, mode, minimum, maximum, range, stddev, variance, diversity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *count*  
    **size**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood diameter in map units  
    **points_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name of points map to use for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Column of points map must be numeric  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for aggregate statistics (count if non given)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *count, sum, average, median, mode, minimum, maximum, range, stddev, variance, diversity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *count*  
    **size** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood diameter in map units  
    **points_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name of points map to use for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Column of points map must be numeric  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for aggregate statistics (count if non given)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *count, sum, average, median, mode, minimum, maximum, range, stddev, variance, diversity*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *count*  
    **size** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Neighborhood diameter in map units  
    **points_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column name of points map to use for statistics  
    &nbsp;&nbsp;&nbsp;&nbsp;Column of points map must be numeric  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This module makes each cell value a function of the attribute values
assigned to the vector points or centroids in an area around the cell
with a diameter of *size* around it, and stores the new cell values in
the *output* raster map layer. By default, the module just counts the
number of points. The user can also choose amongst a variety of
aggregate statistics using the parameter *method*. These statistics are
calculated on the attributes in the *point_column*. Using the usual
*cats* and *where* parameters the user can chose to take only a subset
of the points into account.

Note that *size* is defined as the diameter, and so has to be twice the
wanted search radius, and that the module works within the current
computational region which can be adjusted using
[g.region](g.region.md). If the vector map falls completely outside the
current region, the module will stop with an error.

## EXAMPLE

Count the number of schools for a given grid (North Carolina sample
dataset):

```sh
g.region vector=schools_wake res=100 -p -a
v.neighbors input=schools_wake output=schools_wake_3000m method=count size=3000

d.mon wx0
d.rast schools_wake_3000m
d.vect schools_wake
```

The result gives for each grid cell the number of points (here: schools)
not farther than 1500 meter away (half of the given *size* value) from
the respective cell center.

Calculate the mean capacity of schools for the same grid:

```sh
v.neighbors input=schools_wake output=schools_capacity point_column=CAPACITYTO \
            method=average size=3000
```

## SEE ALSO

*[r.neighbors](r.neighbors.md), [v.vect.stats](v.vect.stats.md)*

## AUTHORS

Radim Blazek,  
Moritz Lennert

## SOURCE CODE

Available at: [v.neighbors source code](https://github.com/OSGeo/grass/tree/main/vector/v.neighbors)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.neighbors))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
