---
name: v.net.curvedarcs.py
description: Draws curved arcs between points (e.g. flows)
keywords: [ vector, network, flows ]
---

# v.net.curvedarcs.py

Draws curved arcs between points (e.g. flows)

=== "Command line"

    **v.net.curvedarcs.py**
    [**-s**]
    **input**=*name*
    [**layer**=*string*]
    **flow_input_file**=*name*
    [**separator**=*character*]
    **output**=*name*
    **minimum_offset**=*float*
    **maximum_offset**=*float*
    [**vertices**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.net.curvedarcs.py input=name flow_input_file=name output=name minimum_offset=0.0 maximum_offset=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.net.curvedarcs.py***",
        **input**,
        **layer**=*"1"*,
        **flow_input_file**,
        **separator**=*"pipe"*,
        **output**,
        **minimum_offset**,
        **maximum_offset**,
        **vertices**=*30*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.net.curvedarcs.py", input="name", flow_input_file="name", output="name", minimum_offset=0.0, maximum_offset=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_net_curvedarcs_py*(**input**,
        **layer**=*"1"*,
        **flow_input_file**,
        **separator**=*"pipe"*,
        **output**,
        **minimum_offset**,
        **maximum_offset**,
        **vertices**=*30*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_net_curvedarcs_py(input="name", flow_input_file="name", output="name", minimum_offset=0.0, maximum_offset=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Point map containing origins and destinations  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to find point categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flow_input_file**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing origins, destinations and flow volumes  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map with curved lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **minimum_offset**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;minimum offset at furthest point from straight line  
    **maximum_offset**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum offset at furthest point from straight line  
    **vertices**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;number of vertices used to draw curved lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Draw also short line for flow from and to same node  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point map containing origins and destinations  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to find point categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flow_input_file** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing origins, destinations and flow volumes  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map with curved lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **minimum_offset** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;minimum offset at furthest point from straight line  
    **maximum_offset** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum offset at furthest point from straight line  
    **vertices** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;number of vertices used to draw curved lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw also short line for flow from and to same node  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Point map containing origins and destinations  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number where to find point categories  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flow_input_file** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;File containing origins, destinations and flow volumes  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Separator used in input text file  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output map with curved lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **minimum_offset** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;minimum offset at furthest point from straight line  
    **maximum_offset** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum offset at furthest point from straight line  
    **vertices** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;number of vertices used to draw curved lines  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Draw also short line for flow from and to same node  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.net.curvedarcs* is a frontend to
*[v.net](https://grass.osgeo.org/grass-stable/manuals/v.net.html)* and
*[v.segment](https://grass.osgeo.org/grass-stable/manuals/v.segment.html)*
that creates curved arcs between given start and end points. The user
provides a point vector map and a text file (see Notes section) with
start and end point categories as well as a flow volume for this link
which will be transferred to the attribute table of the curved arcs.

The user can determine the nature of the curve with the
*minimum\_offset* and *maximum\_offset* parameters. The longest curve's
maximum offset from a straight line is equal to the value of
*maximum\_offset* in map units. The other curves maximum offset from a
straight line is calulated as length(x)/max\_length \* max\_offset. In
other words, shorter lines are less curved than longer lines. However,
any line's maximum offset is always at least *minimum\_offset* from the
straight line.

## NOTES

## EXAMPLE

TODO

```sh
v.extract census_wake2000 cat=1,52,70,99,101 type=centroid out=tmp
v.type tmp from=centroid to=point out=points
echo >> flows.txt << EOF
> from,to,volume
> 52,1,100
> 1,52,50
> 70,1,50
> 1,70,50
> 99,1,66
> 1,99,100
> 101,1,25
> 1,101,75
> EOF
v.net.curvedarcs in=points flow=flows.txt sep=comma out=flows minoff=0 maxoff=2000
d.vect map=flows display=shape,dir width_column=volume width_scale=0.05 size=10
d.vect map=points display=shape,cat fill_color=red icon=basic/circle label_bcolor=black label_size=12 yref=bottom
```

![image-alt](v_net_curvedarcs.png)  
The curved arcs with minimum offset = 150 and maximum offset = 2000

Using different amount of curvature:

```sh
v.net.curvedarcs in=points flow=flows.txt sep=comma out=flows minoff=150 maxoff=5000 --o
d.vect map=flows display=shape,dir width_column=volume width_scale=0.05 size=10
d.vect map=points display=shape,cat fill_color=red icon=basic/circle label_bcolor=black label_size=12 yref=bottom
```

![image-alt](v_net_curvedarcs2.png)  
The curved arcs with minimum offset = 0 and maximum offset = 5000

## SEE ALSO

*[v.net](https://grass.osgeo.org/grass-stable/manuals/v.net.html),
[v.segment](https://grass.osgeo.org/grass-stable/manuals/v.segment.html)*

## AUTHOR

Moritz Lennert, DGES-ULB

## SOURCE CODE

Available at: [v.net.curvedarcs source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.net.curvedarcs)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.net.curvedarcs))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
