---
name: v.ply.rectify.py
description: Imports PLY points, georeferences and exports them.
keywords: [ vector, import, export, rectify ]
---

# v.ply.rectify.py

Imports PLY points, georeferences and exports them.

=== "Command line"

    **v.ply.rectify.py**
    [**-s**]
    **input**=*name*
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.ply.rectify.py input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.ply.rectify.py***",
        **input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.ply.rectify.py", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_ply_rectify_py*(**input**,
        **output**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_ply_rectify_py(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input PLY file  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default is input name without .ply  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Also export point cloud shifted to center  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input PLY file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default is input name without .ply  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also export point cloud shifted to center  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input PLY file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default is input name without .ply  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also export point cloud shifted to center  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.ply.rectify* imports a PLY point cloud, georeferences and exports it.
The first three vertex properties must be the x, y, z coordinates with
property names "x", "y", "z", in this order.

A text file with Ground Control Points (GCPs) must exist in the same
folder where the point cloud is located, and the textfile must have the
same name like the point cloud, but ending on .txt instead of .ply.

The text file with GCPs must have the following format with one GCP per
line:

```text
  x y z east north height status
```

with *x, y, z* as source coordinates and *east, north, height* as target
coordinates. The *status* indicates whether to use a GCP (status is not
zero) or not (status is zero). Entries must be separated by whitespace
or tabs. Decimal delimiters must be points.

The georecitifictation method used is a 3D orthogonal rectification
where angles are preserved. 3D objects are shifted, scaled and rotated,
but no shear is introduced. Please read the output of the module, in
particular the root mean square (RMS) errors.

*v.ply.rectify* optionally exports the georeferenced point cloud not
only with real coordinates, but also with shifted coordinates (*-s*
flag) for display in meshlab or similar software that can not deal with
real coordinates. The exported PLY point clouds will be in the same
folder like the input PLY point cloud.

## EXAMPLE

With a point cloud file *pointcloud.ply* and associated control points
in *pointcloud.txt*,

```sh
v.ply.rectify -s input=pointcloud.ply
```

will generate three files: *pointcloud\_georef.ply* with the
georeferenced point cloud, *pointcloud\_georef\_shifted.ply* with the
georeferenced point cloud shifted to the coordinates' center, and
*pointcloud\_rms.csv* with the RMS errors of the control points.

## SEE ALSO

*[v.in.ply](v.in.ply.md), [v.out.ply](v.out.ply.md),
[v.rectify](https://grass.osgeo.org/grass-stable/manuals/v.rectify.html),
[v.transform](https://grass.osgeo.org/grass-stable/manuals/v.transform.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [v.ply.rectify source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.ply.rectify)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.ply.rectify))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
