---
name: v.rast.move.py
description: Move vertices by distance specified in a raster
keywords: [ vector, transformation, geometry, raster, lines ]
---

# v.rast.move.py

Move vertices by distance specified in a raster

=== "Command line"

    **v.rast.move.py**
    **input**=*name*
    **x_raster**=*name*
    **y_raster**=*name*
    [**nulls**=*string*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.rast.move.py input=name x_raster=name y_raster=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.rast.move.py***",
        **input**,
        **x_raster**,
        **y_raster**,
        **nulls**=*"warning"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.rast.move.py", input="name", x_raster="name", y_raster="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_rast_move_py*(**input**,
        **x_raster**,
        **y_raster**,
        **nulls**=*"warning"*,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_rast_move_py(input="name", x_raster="name", y_raster="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **x_raster**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **y_raster**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **nulls**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Handling of null values  
    &nbsp;&nbsp;&nbsp;&nbsp;zeros;Null value will be converted to zeros;warning;A null value will cause a warning (one for each raster) and will be converted to zero;error;A null value will cause an error  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *zeros, warning, error*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *warning*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **x_raster** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **y_raster** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nulls** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Handling of null values  
    &nbsp;&nbsp;&nbsp;&nbsp;zeros;Null value will be converted to zeros;warning;A null value will cause a warning (one for each raster) and will be converted to zero;error;A null value will cause an error  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *zeros, warning, error*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *warning*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **x_raster** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **y_raster** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **nulls** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Handling of null values  
    &nbsp;&nbsp;&nbsp;&nbsp;zeros;Null value will be converted to zeros;warning;A null value will cause a warning (one for each raster) and will be converted to zero;error;A null value will cause an error  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *zeros, warning, error*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *warning*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.rast.move* takes values from raster maps and adds them to X and Y
coordinates of features in a vector map vertex by vertex. Works on lines
only, other features are ignored and not included in the result. Null
values in rasters are turned into zeros by default and a warning is
generated. This behavior can be modified by the **nulls** option to
either silence the warning with explicit `nulls="zeros"` or the warning
can be turned into an error with `nulls="error"`. The rasters are loaded
based on the computational region, so the most advantageous use of
resources is to set the computational region to match the vector. To
avoid issues with vector coordinates at the border of the computational
region, it is best to also grow the region one cell on each side. Vector
features outside of the computational region always result in an error
being reported (regardless of the **nulls** option), but the rasters can
have any extent as along as the computational region is set to match the
vector.

## NOTES

Unlike *v.perturb* which moves points randomly, *v.rast.move* works on
vertices of lines and uses same value for all vertices at a given cell.
Unlike v.transform used with raster values in attribute columns,
*v.rast.move* operates on individual vertices in the line, not on the
whole line (attributes are associated with features, not their
vertices).

## EXAMPLES

### Shift in X direction

This example uses the North Carolina sample dataset. Set the
computational region to match the vector map and use 100-meter
resolution.

```sh
g.region vector=roadsmajor res=100
```

Generate rasters for a shift in X direction (one raster is a wave, the
other is zero):

```sh
g.region vector=roadsmajor res=100
r.mapcalc expression="a = 1000 * sin(row())"
r.mapcalc expression="b = 0"
```

Use the rasters to move the vector:

```sh
v.rast.move input=roadsmajor output=roads_moved x_raster=a y_raster=b
```

[![image-alt](v_rast_move.png)](v_rast_move.png)  
*Figure: Original (blue) and shifted (red) road network and the X shift
values in diverging blue-white-red colors (red shift right, blue shift
left, white no shift)*

## SEE ALSO

- *[v.transform](v.transform.md)* for changing coordinates for the
    whole vector map or feature by feature based on the attributes,
- *[v.perturb](v.perturb.md)* for randomly changing point positions by
    small amounts,
- *[r.mapcalc](r.mapcalc.md)* for generating or adjusting the raster
    maps,
- *[g.region](g.region.md)* to set the computational region before the
    computation.

## AUTHOR

Vaclav Petras, [NCSU Center for Geospatial Analytics, GeoForAll
Lab](https://cnr.ncsu.edu/geospatial)

## SOURCE CODE

Available at: [v.rast.move source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.rast.move)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.rast.move))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
