---
name: v.tin.to.rast.py
description: Converts (rasterize) a TIN map into a raster map
keywords: [ vector, raster, TIN, conversion ]
---

# v.tin.to.rast.py

Converts (rasterize) a TIN map into a raster map

=== "Command line"

    **v.tin.to.rast.py**
    **input**=*name*
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.tin.to.rast.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.tin.to.rast.py***",
        **input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.tin.to.rast.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_tin_to_rast_py*(**input**,
        **output**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_tin_to_rast_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TIN map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TIN map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TIN map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TIN map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TIN map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input TIN map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.tin.to.rast* converts (rasterizes) a TIN map into a raster map.

## EXAMPLE

Example of *v.tin.to.rast* usage (North Carolina sample data set).
Preparation of a TIN (Delaunay triangulation) from geodetic points, then
rasterization of the TIN:

```sh
# work on a copy of the original geodetic points map
g.copy vector=geodetic_pts,mygeodetic_pts

# data preparation: convert z-values from string to double format
v.db.addcolumn map=mygeodetic_pts columns="Z_VALUE_D double precision"
v.db.update map=mygeodetic_pts column=Z_VALUE_D qcolumn=Z_VALUE

# verify: should show identical z-values
v.db.select map=mygeodetic_pts columns=cat,Z_VALUE,Z_VALUE_D

# convert 2D vector point map to 3D based on attribute
v.to.3d input=mygeodetic_pts output=mygeodetic_pts_3d column=Z_VALUE_D

# create TIN
v.delaunay input=mygeodetic_pts_3d output=mygeodetic_pts_3d_delaunay

# rasterize TIN to 500m resolution raster map
g.region vector=mygeodetic_pts_3d_delaunay res=500 -p
v.tin.to.rast input=mygeodetic_pts_3d_delaunay output=mygeodetic_pts_3d_delaunay
r.colors mygeodetic_pts_3d_delaunay color=srtm_plus
```

## SEE ALSO

*[v.delaunay](https://grass.osgeo.org/grass-stable/manuals/v.delaunay.html)*

## AUTHORS

Antonio Alliegro, Alexander Muriy  
Example: Markus Neteler

## SOURCE CODE

Available at: [v.tin.to.rast source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.tin.to.rast)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.tin.to.rast))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
