---
name: v.vol.idw
description: Interpolates point data to a 3D raster map using Inverse Distance Weighting (IDW) algorithm.
keywords: [ vector, Volume, voxel, interpolation, IDW ]
---

# v.vol.idw

Interpolates point data to a 3D raster map using Inverse Distance Weighting (IDW) algorithm.

=== "Command line"

    **v.vol.idw**
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    **column**=*name*
    **npoints**=*count*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.vol.idw input=name output=name column=name npoints=12
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.vol.idw***",
        **input**,
        **layer**=*"1"*,
        **output**,
        **column**,
        **npoints**=*12*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.vol.idw", input="name", output="name", column="name", npoints=12)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_vol_idw*(**input**,
        **layer**=*"1"*,
        **output**,
        **column**,
        **npoints**=*12*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_vol_idw(input="name", output="name", column="name", npoints=12)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D vector points map  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vector layer field attribute to use for calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column (data type must be numeric)  
    **npoints**=*count* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vector layer field attribute to use for calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column (data type must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **npoints** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input 3D vector points map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of vector layer field attribute to use for calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output 3D raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster_3d, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column (data type must be numeric)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **npoints** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of interpolation points  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *count*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *12*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.vol.idw* fills a RASTER3D raster volume matrix with interpolated
values generated from a set of irregularly spaced data points using
numerical approximation (weighted averaging) techniques. The
interpolated value of a tile is determined by values of nearby data
points and the distance of the cell from those input points. In
comparison with other methods, numerical approximation allows
representation of more complex volumes (particularly those with
anomalous features), restricts the spatial influence of any errors, and
generates the interpolated volume from the data points.

## EXAMPLE

```sh
v.vol.idw input=map output=rastermap3d column=col_name npoints=36
```

## SEE ALSO

*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html),
[v.in.db](https://grass.osgeo.org/grass-stable/manuals/v.in.db.html),
[v.surf.idw](https://grass.osgeo.org/grass-stable/manuals/v.surf.idw.html),
[v.vol.rst](https://grass.osgeo.org/grass-stable/manuals/v.vol.rst.html),
[v.to.rast3](https://grass.osgeo.org/grass-stable/manuals/v.to.rast3.html)*

## AUTHOR

Jaro Hofierka, Department of Geography and Regional Development,
University of Presov, Presov, Slovakia, <hofierka@geomodel.sk>  

Modifications for raster3d library and vector format:  
Noortheen Raja J, Institute of Remote Sensing, College of Engineering,
Guindy, Anna University, India. <jnoortheen@gmail.com>

## SOURCE CODE

Available at: [v.vol.idw source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.vol.idw)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.vol.idw))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
