---
name: wxpyimgview.py
description: Views BMP images from the PNG driver.
keywords: [ display, graphics, raster ]
---

# wxpyimgview.py

Views BMP images from the PNG driver.

=== "Command line"

    **wxpyimgview.py**
    **image**=*name*
    [**percent**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    wxpyimgview.py image=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***wxpyimgview.py***",
        **image**,
        **percent**=*10*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("wxpyimgview.py", image="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.wxpyimgview_py*(**image**,
        **percent**=*10*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.wxpyimgview_py(image="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **image**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input image file  
    **percent**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of CPU time to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **image** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **percent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of CPU time to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **image** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input image file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **percent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of CPU time to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*wxpyimgview* is a simple wxWidgets image viewer for 32-bpp BMP images,
as can be created with the *[PNG](pngdriver.md)* and
*[cairo](cairodriver.md)* drivers. The display is continually refreshed.

## NOTES

The display driver must be configure to map the file, with
*GRASS_RENDER_FILE_MAPPED=TRUE*. This ensures that the file will remain
a constant size, rather than being truncated whenever it is updated.

## SEE ALSO

*[PNG driver](pngdriver.md), [cairo driver](cairodriver.md)*

## AUTHOR

Glynn Clements

## SOURCE CODE

Available at: [wxpyimgview source code](https://github.com/OSGeo/grass/tree/main/scripts/wxpyimgview)
([history](https://github.com/OSGeo/grass/commits/main/scripts/wxpyimgview))  
Latest change: Friday Mar 07 23:20:43 2025 in commit [b94776a](https://github.com/OSGeo/grass/commit/b94776ae711b613e98849395a1b4635336af9479)
